package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type ListGardenTasksJsonView struct {
	GardenTaskSerializer *serializers.GardenTaskSerializer
}

func (this *ListGardenTasksJsonView) Json(maeOut *maes.ListGardenTasksMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		return json.Marshal(m)
	}
	m["items"], err = this.gardenTasksToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["page"], err = this.gardenTasksPaginationToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["list"], err = this.listToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *ListGardenTasksJsonView) gardenTasksToJson(maeOut *maes.ListGardenTasksMaeOut) (json.RawMessage, error) {
	return this.GardenTaskSerializer.SetToJson(maeOut.Response.GardenTasks)
}
func (this *ListGardenTasksJsonView) gardenTasksPaginationToJson(maeOut *maes.ListGardenTasksMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.GardenTasksPagination)
}
func (this *ListGardenTasksJsonView) listToJson(maeOut *maes.ListGardenTasksMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.List)
}
