package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type ListGardensJsonView struct {
	GardenSerializer *serializers.GardenSerializer
}

func (this *ListGardensJsonView) Json(maeOut *maes.ListGardensMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		return json.Marshal(m)
	}
	m["items"], err = this.gardensToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["page"], err = this.gardensPaginationToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["list"], err = this.listToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *ListGardensJsonView) gardensToJson(maeOut *maes.ListGardensMaeOut) (json.RawMessage, error) {
	return this.GardenSerializer.SetToJson(maeOut.Response.Gardens)
}
func (this *ListGardensJsonView) gardensPaginationToJson(maeOut *maes.ListGardensMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.GardensPagination)
}
func (this *ListGardensJsonView) listToJson(maeOut *maes.ListGardensMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.List)
}
