package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type ListPlantTasksJsonView struct {
	PlantTaskSerializer *serializers.PlantTaskSerializer
}

func (this *ListPlantTasksJsonView) Json(maeOut *maes.ListPlantTasksMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		return json.Marshal(m)
	}
	m["items"], err = this.plantTasksToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["page"], err = this.plantTasksPaginationToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["list"], err = this.listToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *ListPlantTasksJsonView) plantTasksToJson(maeOut *maes.ListPlantTasksMaeOut) (json.RawMessage, error) {
	return this.PlantTaskSerializer.SetToJson(maeOut.Response.PlantTasks)
}
func (this *ListPlantTasksJsonView) plantTasksPaginationToJson(maeOut *maes.ListPlantTasksMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.PlantTasksPagination)
}
func (this *ListPlantTasksJsonView) listToJson(maeOut *maes.ListPlantTasksMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.List)
}
