package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type ListPlantationsJsonView struct {
	PlantationSerializer *serializers.PlantationSerializer
}

func (this *ListPlantationsJsonView) Json(maeOut *maes.ListPlantationsMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		return json.Marshal(m)
	}
	m["items"], err = this.plantationsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["page"], err = this.plantationsPaginationToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["list"], err = this.listToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *ListPlantationsJsonView) plantationsToJson(maeOut *maes.ListPlantationsMaeOut) (json.RawMessage, error) {
	return this.PlantationSerializer.SetToJson(maeOut.Response.Plantations)
}
func (this *ListPlantationsJsonView) plantationsPaginationToJson(maeOut *maes.ListPlantationsMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.PlantationsPagination)
}
func (this *ListPlantationsJsonView) listToJson(maeOut *maes.ListPlantationsMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.List)
}
