package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type ListPlantsJsonView struct {
	PlantSerializer *serializers.PlantSerializer
}

func (this *ListPlantsJsonView) Json(maeOut *maes.ListPlantsMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		return json.Marshal(m)
	}
	m["items"], err = this.plantsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["page"], err = this.plantsPaginationToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["list"], err = this.listToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *ListPlantsJsonView) plantsToJson(maeOut *maes.ListPlantsMaeOut) (json.RawMessage, error) {
	return this.PlantSerializer.SetToJson(maeOut.Response.Plants)
}
func (this *ListPlantsJsonView) plantsPaginationToJson(maeOut *maes.ListPlantsMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.PlantsPagination)
}
func (this *ListPlantsJsonView) listToJson(maeOut *maes.ListPlantsMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.List)
}
