package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type ListSeedProgramsJsonView struct {
	SeedProgramSerializer *serializers.SeedProgramSerializer
}

func (this *ListSeedProgramsJsonView) Json(maeOut *maes.ListSeedProgramsMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		return json.Marshal(m)
	}
	m["items"], err = this.seedProgramsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["page"], err = this.seedProgramsPaginationToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["list"], err = this.listToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *ListSeedProgramsJsonView) seedProgramsToJson(maeOut *maes.ListSeedProgramsMaeOut) (json.RawMessage, error) {
	return this.SeedProgramSerializer.SetToJson(maeOut.Response.SeedPrograms)
}
func (this *ListSeedProgramsJsonView) seedProgramsPaginationToJson(maeOut *maes.ListSeedProgramsMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.SeedProgramsPagination)
}
func (this *ListSeedProgramsJsonView) listToJson(maeOut *maes.ListSeedProgramsMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.List)
}
