package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type ListUsersJsonView struct {
	UserSerializer *serializers.UserSerializer
}

func (this *ListUsersJsonView) Json(maeOut *maes.ListUsersMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		return json.Marshal(m)
	}
	m["items"], err = this.usersToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["page"], err = this.usersPaginationToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["list"], err = this.listToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *ListUsersJsonView) usersToJson(maeOut *maes.ListUsersMaeOut) (json.RawMessage, error) {
	return this.UserSerializer.SetToJson(maeOut.Response.Users)
}
func (this *ListUsersJsonView) usersPaginationToJson(maeOut *maes.ListUsersMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.UsersPagination)
}
func (this *ListUsersJsonView) listToJson(maeOut *maes.ListUsersMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.List)
}
