package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type UpdateGardenJsonView struct {
	GardenSerializer *serializers.GardenSerializer
}

func (this *UpdateGardenJsonView) Json(maeOut *maes.UpdateGardenMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		m["form_bag"] = maeOut.Response.FormBag
		return json.Marshal(m)
	}
	m["item"], err = this.gardenToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_bag"], err = this.formBagToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_fields"], err = this.formFieldsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *UpdateGardenJsonView) gardenToJson(maeOut *maes.UpdateGardenMaeOut) (json.RawMessage, error) {
	return this.GardenSerializer.OneToJson(maeOut.Response.Garden)
}
func (this *UpdateGardenJsonView) formBagToJson(maeOut *maes.UpdateGardenMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormBag)
}
func (this *UpdateGardenJsonView) formFieldsToJson(maeOut *maes.UpdateGardenMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormFields)
}
