package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type UpdateGardenTaskJsonView struct {
	GardenTaskSerializer *serializers.GardenTaskSerializer
}

func (this *UpdateGardenTaskJsonView) Json(maeOut *maes.UpdateGardenTaskMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		m["form_bag"] = maeOut.Response.FormBag
		return json.Marshal(m)
	}
	m["item"], err = this.gardenTaskToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_bag"], err = this.formBagToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_fields"], err = this.formFieldsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *UpdateGardenTaskJsonView) gardenTaskToJson(maeOut *maes.UpdateGardenTaskMaeOut) (json.RawMessage, error) {
	return this.GardenTaskSerializer.OneToJson(maeOut.Response.GardenTask)
}
func (this *UpdateGardenTaskJsonView) formBagToJson(maeOut *maes.UpdateGardenTaskMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormBag)
}
func (this *UpdateGardenTaskJsonView) formFieldsToJson(maeOut *maes.UpdateGardenTaskMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormFields)
}
