package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type UpdatePlantJsonView struct {
	PlantSerializer *serializers.PlantSerializer
}

func (this *UpdatePlantJsonView) Json(maeOut *maes.UpdatePlantMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		m["form_bag"] = maeOut.Response.FormBag
		return json.Marshal(m)
	}
	m["item"], err = this.plantToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_bag"], err = this.formBagToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_fields"], err = this.formFieldsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *UpdatePlantJsonView) plantToJson(maeOut *maes.UpdatePlantMaeOut) (json.RawMessage, error) {
	return this.PlantSerializer.OneToJson(maeOut.Response.Plant)
}
func (this *UpdatePlantJsonView) formBagToJson(maeOut *maes.UpdatePlantMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormBag)
}
func (this *UpdatePlantJsonView) formFieldsToJson(maeOut *maes.UpdatePlantMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormFields)
}
