package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type UpdatePlantTaskJsonView struct {
	PlantTaskSerializer *serializers.PlantTaskSerializer
}

func (this *UpdatePlantTaskJsonView) Json(maeOut *maes.UpdatePlantTaskMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		m["form_bag"] = maeOut.Response.FormBag
		return json.Marshal(m)
	}
	m["item"], err = this.plantTaskToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_bag"], err = this.formBagToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_fields"], err = this.formFieldsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *UpdatePlantTaskJsonView) plantTaskToJson(maeOut *maes.UpdatePlantTaskMaeOut) (json.RawMessage, error) {
	return this.PlantTaskSerializer.OneToJson(maeOut.Response.PlantTask)
}
func (this *UpdatePlantTaskJsonView) formBagToJson(maeOut *maes.UpdatePlantTaskMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormBag)
}
func (this *UpdatePlantTaskJsonView) formFieldsToJson(maeOut *maes.UpdatePlantTaskMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormFields)
}
