package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type UpdateSeedProgramJsonView struct {
	SeedProgramSerializer *serializers.SeedProgramSerializer
}

func (this *UpdateSeedProgramJsonView) Json(maeOut *maes.UpdateSeedProgramMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		m["form_bag"] = maeOut.Response.FormBag
		return json.Marshal(m)
	}
	m["item"], err = this.seedProgramToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_bag"], err = this.formBagToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_fields"], err = this.formFieldsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *UpdateSeedProgramJsonView) seedProgramToJson(maeOut *maes.UpdateSeedProgramMaeOut) (json.RawMessage, error) {
	return this.SeedProgramSerializer.OneToJson(maeOut.Response.SeedProgram)
}
func (this *UpdateSeedProgramJsonView) formBagToJson(maeOut *maes.UpdateSeedProgramMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormBag)
}
func (this *UpdateSeedProgramJsonView) formFieldsToJson(maeOut *maes.UpdateSeedProgramMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormFields)
}
