package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type UpdateUserJsonView struct {
	UserSerializer *serializers.UserSerializer
}

func (this *UpdateUserJsonView) Json(maeOut *maes.UpdateUserMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		m["form_bag"] = maeOut.Response.FormBag
		return json.Marshal(m)
	}
	m["item"], err = this.userToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_bag"], err = this.formBagToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_fields"], err = this.formFieldsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *UpdateUserJsonView) userToJson(maeOut *maes.UpdateUserMaeOut) (json.RawMessage, error) {
	return this.UserSerializer.OneToJson(maeOut.Response.User)
}
func (this *UpdateUserJsonView) formBagToJson(maeOut *maes.UpdateUserMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormBag)
}
func (this *UpdateUserJsonView) formFieldsToJson(maeOut *maes.UpdateUserMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormFields)
}
