package layouts

// |@@| C

import (
	"gardening/src/lib/kit"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type StructuredLayout struct {
	Kit    *kit.Kit
	Layout *Layout
}

type Structure struct {
	Rows []*Row
}

type Row struct {
	SectionIndex int
	Columns      []*Column
}

type Column struct {
	SectionIndex int
	Width        string
}

func (this *Structure) AddSectionRow(sectionIndex int) {
	this.Rows = append(this.Rows, &Row{SectionIndex: sectionIndex})
}

func (this *Structure) AddEqualColumnsRow(sectionIndex ...int) {
	row := &Row{}
	this.Rows = append(this.Rows, row)
	for _, i := range sectionIndex {
		row.Columns = append(row.Columns, &Column{SectionIndex: i})
	}
}

func (this *StructuredLayout) H(sections []goc.HTML, structure Structure, mod *LayoutMod) goc.HTML {
	mod.Content = this.content(sections, structure)
	return this.Layout.H(mod)
}

func (this *StructuredLayout) content(sections []goc.HTML, structure Structure) goc.HTML {
	var set []goc.HTML

	for _, row := range structure.Rows {
		if len(row.Columns) == 0 {
			section := sections[row.SectionIndex]
			set = append(set, this.Kit.Component.Dcs("w-full", section))
			continue
		}
		var set2 []goc.HTML
		for _, column := range row.Columns {
			section := sections[column.SectionIndex]
			set2 = append(set2, this.Kit.Component.Dcs("w-full", section))
		}
		set = append(set, this.Kit.Component.Dcs("flex flex-row space-x-4", set2...))
	}

	return this.Kit.Component.Cas("div",
		goc.Attr{"class": "mt-8 space-y-6 flex flex-col"},
		set...,
	)
}
