package menus

// |@@| C

import (
	"gardening/src/lib/kit"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/menus"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type SettingsMenu struct {
	AppUrler *urlers.AppUrler
	Kit      *kit.Kit
}

func (this *SettingsMenu) H() goc.HTML {
	menuMod := this.Kit.Organisms.Menus.Menu.Mod()
	menuMod.AddItem("plants", "Plants", this.AppUrler.ListPlants())
	menuMod.AddItem("users", "Users", this.AppUrler.ListUsers())
	return this.Kit.Organisms.Menus.Menu.TopMenu(menuMod)
}
func (this *SettingsMenu) GetMenuItems() []*menus.MenuItem {
	var items []*menus.MenuItem
	items = append(items, &menus.MenuItem{
		Name: "Plants",
		Url:  this.AppUrler.ListPlants(),
	})
	items = append(items, &menus.MenuItem{
		Name: "Users",
		Url:  this.AppUrler.ListUsers(),
	})
	return items
}
