package menus

// |@@| C

import (
	"gardening/src/lib/kit"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/menus"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type TopMenu struct {
	AppUrler *urlers.AppUrler
	Kit      *kit.Kit
}

func (this *TopMenu) H() goc.HTML {
	menuMod := this.Kit.Organisms.Menus.Menu.Mod()
	menuMod.AddItem("gardens", "Gardens", this.AppUrler.ListGardens())
	menuMod.AddItem("plant_tasks", "Plant tasks", this.AppUrler.ListPlantTasks())
	menuMod.AddItem("settings", "Settings", this.AppUrler.ListPlantTasks())
	return this.Kit.Organisms.Menus.Menu.TopMenu(menuMod)
}
func (this *TopMenu) GetMenuItems() []*menus.MenuItem {
	var items []*menus.MenuItem
	items = append(items, &menus.MenuItem{
		Name: "Gardens",
		Url:  this.AppUrler.ListGardens(),
	})
	items = append(items, &menus.MenuItem{
		Name: "Plant Tasks",
		Url:  this.AppUrler.ListPlantTasks(),
	})
	items = append(items, &menus.MenuItem{
		Name: "Settings",
		Url:  this.AppUrler.ListPlantTasks(),
	})
	return items
}
