package molders

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/mdl"
)

type UpdatePlantFormMolder struct {
}

func (this *UpdatePlantFormMolder) ToEntity(form *forms.UpdatePlantForm, entity *mdl.Plant) (*mdl.Plant, []string) {
	var changes []string
	if string(entity.Data) != string(form.Data) {
		entity.Data = form.Data
		changes = append(changes, "Data")
	}
	if entity.Description != form.Description {
		entity.Description = form.Description
		changes = append(changes, "Description")
	}
	if entity.Exposition != form.Exposition {
		entity.Exposition = form.Exposition
		changes = append(changes, "Exposition")
	}
	if entity.Harvested != form.Harvested {
		entity.Harvested = form.Harvested
		changes = append(changes, "Harvested")
	}
	if entity.Name != form.Name {
		entity.Name = form.Name
		changes = append(changes, "Name")
	}
	if entity.Perennial != form.Perennial {
		entity.Perennial = form.Perennial
		changes = append(changes, "Perennial")
	}
	if entity.Reference != form.Reference {
		entity.Reference = form.Reference
		changes = append(changes, "Reference")
	}
	if entity.Size != form.Size {
		entity.Size = form.Size
		changes = append(changes, "Size")
	}
	return entity, changes
}
func (this *UpdatePlantFormMolder) ToForm(form *forms.UpdatePlantForm, entity *mdl.Plant) *forms.UpdatePlantForm {
	form.Id = entity.Id
	form.Data = entity.Data
	form.Description = entity.Description
	form.Exposition = entity.Exposition
	form.Harvested = entity.Harvested
	form.Name = entity.Name
	form.Perennial = entity.Perennial
	form.Reference = entity.Reference
	form.Size = entity.Size
	return form
}
