package molders

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/mdl"
)

type UpdatePlantationFormMolder struct {
}

func (this *UpdatePlantationFormMolder) ToEntity(form *forms.UpdatePlantationForm, entity *mdl.Plantation) (*mdl.Plantation, []string) {
	var changes []string
	if entity.Name != form.Name {
		entity.Name = form.Name
		changes = append(changes, "Name")
	}
	if entity.PlantedAt != form.PlantedAt {
		entity.PlantedAt = form.PlantedAt
		changes = append(changes, "PlantedAt")
	}
	if entity.PlantId != form.PlantId {
		entity.PlantId = form.PlantId
		changes = append(changes, "PlantId")
	}
	if entity.GardenId != form.GardenId {
		entity.GardenId = form.GardenId
		changes = append(changes, "GardenId")
	}
	return entity, changes
}
func (this *UpdatePlantationFormMolder) ToForm(form *forms.UpdatePlantationForm, entity *mdl.Plantation) *forms.UpdatePlantationForm {
	form.Id = entity.Id
	form.Name = entity.Name
	form.PlantedAt = entity.PlantedAt
	form.PlantId = entity.PlantId
	form.GardenId = entity.GardenId
	return form
}
