package presenters

// |@@| C

import (
	"context"
	"gardening/src/lib/filter"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/illustrers/garden"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type GardenPresenter struct {
	GardenPrimaryColumnIllustrer *illustrers.GardenPrimaryColumnIllustrer
	GardenSearchIllustrer        *illustrers.GardenSearchIllustrer
	Kit                          *kit.Kit
	Presenter                    *presenter.Presenter
}

func (this *GardenPresenter) PrimaryColumn(ctx context.Context, entity *mdl.Garden) goc.HTML {
	return this.GardenPrimaryColumnIllustrer.Act(ctx, &illustrers.GardenPrimaryColumnIllustrerMod{Entity: entity})
}
func (this *GardenPresenter) IdDataColumn(entity *mdl.Garden) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *GardenPresenter) CreatedAtDataColumn(entity *mdl.Garden) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *GardenPresenter) UpdatedAtDataColumn(entity *mdl.Garden) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *GardenPresenter) NameDataColumn(entity *mdl.Garden) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *GardenPresenter) PictureDataColumn(entity *mdl.Garden) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Picture)
}
func (this *GardenPresenter) ColumnByKey(key string, entity *mdl.Garden) goc.HTML {
	switch key {
	case "id":
		return this.IdDataColumn(entity)
	case "created_at":
		return this.CreatedAtDataColumn(entity)
	case "updated_at":
		return this.UpdatedAtDataColumn(entity)
	case "name":
		return this.NameDataColumn(entity)
	case "picture":
		return this.PictureDataColumn(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *GardenPresenter) Columns(filter string) []*presenter.Column {
	var columns []*presenter.Column
	columns = append(columns, &presenter.Column{
		Key:   "id",
		Label: "Id",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "created_at",
		Label: "Created At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "updated_at",
		Label: "Updated At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "name",
		Label: "Name",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "picture",
		Label: "Picture",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	return this.Presenter.FilteredColumns(columns, filter)
}
func (this *GardenPresenter) Search(ctx context.Context, value *searcher.SearchValue, entity *mdl.Garden) goc.HTML {
	return this.GardenSearchIllustrer.Act(ctx, &illustrers.GardenSearchIllustrerMod{Entity: entity, Value: value})
}
func (this *GardenPresenter) Filters(ctx context.Context) []filter.Filter {
	filters := filter.Filters{}
	filters.AddIdFilter("id")
	filters.AddStringFilter("name")
	return filters
}
