package presenters

// |@@| C

import (
	"context"
	"gardening/src/lib/filter"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/illustrers/garden_task"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type GardenTaskPresenter struct {
	AppUrler                         *urlers.AppUrler
	GardenStringer                   *stringers.GardenStringer
	GardenTaskPrimaryColumnIllustrer *illustrers.GardenTaskPrimaryColumnIllustrer
	GardenTaskSearchIllustrer        *illustrers.GardenTaskSearchIllustrer
	Kit                              *kit.Kit
	PlantationStringer               *stringers.PlantationStringer
	Presenter                        *presenter.Presenter
}

func (this *GardenTaskPresenter) PrimaryColumn(ctx context.Context, entity *mdl.GardenTask) goc.HTML {
	return this.GardenTaskPrimaryColumnIllustrer.Act(ctx, &illustrers.GardenTaskPrimaryColumnIllustrerMod{Entity: entity})
}
func (this *GardenTaskPresenter) IdDataColumn(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *GardenTaskPresenter) CreatedAtDataColumn(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *GardenTaskPresenter) UpdatedAtDataColumn(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *GardenTaskPresenter) DescriptionDataColumn(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Description)
}
func (this *GardenTaskPresenter) NameDataColumn(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *GardenTaskPresenter) StartDateDataColumn(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.StartDate.Format("02/01/2006 15:04"))
}
func (this *GardenTaskPresenter) GardenIdDataColumn(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.RelationCell.RelationCell(
		entity.Id, this.GardenStringer.MustToString(entity.Garden),
		this.AppUrler.ShowGarden(entity.Id),
	)
}
func (this *GardenTaskPresenter) PlantationIdDataColumn(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.RelationCell.RelationCell(
		entity.Id, this.PlantationStringer.MustToString(entity.Plantation),
		this.AppUrler.ShowPlantation(entity.Id),
	)
}
func (this *GardenTaskPresenter) ColumnByKey(key string, entity *mdl.GardenTask) goc.HTML {
	switch key {
	case "id":
		return this.IdDataColumn(entity)
	case "created_at":
		return this.CreatedAtDataColumn(entity)
	case "updated_at":
		return this.UpdatedAtDataColumn(entity)
	case "description":
		return this.DescriptionDataColumn(entity)
	case "name":
		return this.NameDataColumn(entity)
	case "start_date":
		return this.StartDateDataColumn(entity)
	case "garden_id":
		return this.GardenIdDataColumn(entity)
	case "plantation_id":
		return this.PlantationIdDataColumn(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *GardenTaskPresenter) Columns(filter string) []*presenter.Column {
	var columns []*presenter.Column
	columns = append(columns, &presenter.Column{
		Key:   "id",
		Label: "Id",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "created_at",
		Label: "Created At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "updated_at",
		Label: "Updated At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "description",
		Label: "Description",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "name",
		Label: "Name",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "start_date",
		Label: "Start Date",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "garden_id",
		Label: "Garden",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "plantation_id",
		Label: "Plantation",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	return this.Presenter.FilteredColumns(columns, filter)
}
func (this *GardenTaskPresenter) Search(ctx context.Context, value *searcher.SearchValue, entity *mdl.GardenTask) goc.HTML {
	return this.GardenTaskSearchIllustrer.Act(ctx, &illustrers.GardenTaskSearchIllustrerMod{Entity: entity, Value: value})
}
func (this *GardenTaskPresenter) Filters(ctx context.Context) []filter.Filter {
	filters := filter.Filters{}
	filters.AddIdFilter("id")
	filters.AddStringFilter("name")
	filters.AddRelationIdFilter("garden_id")
	filters.AddRelationIdFilter("plantation_id")
	return filters
}
