package presenters

// |@@| C

import (
	"context"
	"gardening/src/lib/filter"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/illustrers/plant"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantPresenter struct {
	Kit                         *kit.Kit
	PlantPrimaryColumnIllustrer *illustrers.PlantPrimaryColumnIllustrer
	PlantSearchIllustrer        *illustrers.PlantSearchIllustrer
	Presenter                   *presenter.Presenter
}

func (this *PlantPresenter) PrimaryColumn(ctx context.Context, entity *mdl.Plant) goc.HTML {
	return this.PlantPrimaryColumnIllustrer.Act(ctx, &illustrers.PlantPrimaryColumnIllustrerMod{Entity: entity})
}
func (this *PlantPresenter) IdDataColumn(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *PlantPresenter) CreatedAtDataColumn(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *PlantPresenter) UpdatedAtDataColumn(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *PlantPresenter) DataDataColumn(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(string(entity.Data))
}
func (this *PlantPresenter) DescriptionDataColumn(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Description)
}
func (this *PlantPresenter) ExpositionDataColumn(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Exposition)
}
func (this *PlantPresenter) HarvestedDataColumn(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.DecimalCell.DecimalCell(entity.Harvested)
}
func (this *PlantPresenter) NameDataColumn(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *PlantPresenter) PerennialDataColumn(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.BooleanCell.BooleanCell(entity.Perennial)
}
func (this *PlantPresenter) PlantingSchemaDataColumn(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell("WIP")
}
func (this *PlantPresenter) ReferenceDataColumn(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Reference)
}
func (this *PlantPresenter) SizeDataColumn(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.IntegerCell.IntegerCell(entity.Size)
}
func (this *PlantPresenter) ColumnByKey(key string, entity *mdl.Plant) goc.HTML {
	switch key {
	case "id":
		return this.IdDataColumn(entity)
	case "created_at":
		return this.CreatedAtDataColumn(entity)
	case "updated_at":
		return this.UpdatedAtDataColumn(entity)
	case "data":
		return this.DataDataColumn(entity)
	case "description":
		return this.DescriptionDataColumn(entity)
	case "exposition":
		return this.ExpositionDataColumn(entity)
	case "harvested":
		return this.HarvestedDataColumn(entity)
	case "name":
		return this.NameDataColumn(entity)
	case "perennial":
		return this.PerennialDataColumn(entity)
	case "planting_schema":
		return this.PlantingSchemaDataColumn(entity)
	case "reference":
		return this.ReferenceDataColumn(entity)
	case "size":
		return this.SizeDataColumn(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *PlantPresenter) Columns(filter string) []*presenter.Column {
	var columns []*presenter.Column
	columns = append(columns, &presenter.Column{
		Key:   "id",
		Label: "Id",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "created_at",
		Label: "Created At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "updated_at",
		Label: "Updated At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "data",
		Label: "Data",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "description",
		Label: "Description",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "exposition",
		Label: "Exposition",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "harvested",
		Label: "Harvested",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "name",
		Label: "Name",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "perennial",
		Label: "Perennial",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "planting_schema",
		Label: "Planting Schema",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "reference",
		Label: "Reference",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "size",
		Label: "Size",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	return this.Presenter.FilteredColumns(columns, filter)
}
func (this *PlantPresenter) Search(ctx context.Context, value *searcher.SearchValue, entity *mdl.Plant) goc.HTML {
	return this.PlantSearchIllustrer.Act(ctx, &illustrers.PlantSearchIllustrerMod{Entity: entity, Value: value})
}
func (this *PlantPresenter) Filters(ctx context.Context) []filter.Filter {
	filters := filter.Filters{}
	filters.AddIdFilter("id")
	filters.AddStringFilter("exposition")
	filters.AddStringFilter("name")
	filters.AddBooleanFilter("perennial")
	filters.AddStringFilter("reference")
	filters.AddIntegerFilter("size")
	return filters
}
