package presenters

// |@@| C

import (
	"context"
	"gardening/src/lib/filter"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/illustrers/plant_task"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantTaskPresenter struct {
	AppUrler                        *urlers.AppUrler
	Kit                             *kit.Kit
	PlantStringer                   *stringers.PlantStringer
	PlantTaskPrimaryColumnIllustrer *illustrers.PlantTaskPrimaryColumnIllustrer
	PlantTaskSearchIllustrer        *illustrers.PlantTaskSearchIllustrer
	Presenter                       *presenter.Presenter
}

func (this *PlantTaskPresenter) PrimaryColumn(ctx context.Context, entity *mdl.PlantTask) goc.HTML {
	return this.PlantTaskPrimaryColumnIllustrer.Act(ctx, &illustrers.PlantTaskPrimaryColumnIllustrerMod{Entity: entity})
}
func (this *PlantTaskPresenter) IdDataColumn(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *PlantTaskPresenter) CreatedAtDataColumn(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *PlantTaskPresenter) UpdatedAtDataColumn(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *PlantTaskPresenter) DescriptionDataColumn(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Description)
}
func (this *PlantTaskPresenter) NameDataColumn(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *PlantTaskPresenter) StartDateDataColumn(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.StartDate.Format("02/01/2006 15:04"))
}
func (this *PlantTaskPresenter) PlantIdDataColumn(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.RelationCell.RelationCell(
		entity.Id, this.PlantStringer.MustToString(entity.Plant),
		this.AppUrler.ShowPlant(entity.Id),
	)
}
func (this *PlantTaskPresenter) ColumnByKey(key string, entity *mdl.PlantTask) goc.HTML {
	switch key {
	case "id":
		return this.IdDataColumn(entity)
	case "created_at":
		return this.CreatedAtDataColumn(entity)
	case "updated_at":
		return this.UpdatedAtDataColumn(entity)
	case "description":
		return this.DescriptionDataColumn(entity)
	case "name":
		return this.NameDataColumn(entity)
	case "start_date":
		return this.StartDateDataColumn(entity)
	case "plant_id":
		return this.PlantIdDataColumn(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *PlantTaskPresenter) Columns(filter string) []*presenter.Column {
	var columns []*presenter.Column
	columns = append(columns, &presenter.Column{
		Key:   "id",
		Label: "Id",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "created_at",
		Label: "Created At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "updated_at",
		Label: "Updated At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "description",
		Label: "Description",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "name",
		Label: "Name",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "start_date",
		Label: "Start Date",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "plant_id",
		Label: "Plant",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	return this.Presenter.FilteredColumns(columns, filter)
}
func (this *PlantTaskPresenter) Search(ctx context.Context, value *searcher.SearchValue, entity *mdl.PlantTask) goc.HTML {
	return this.PlantTaskSearchIllustrer.Act(ctx, &illustrers.PlantTaskSearchIllustrerMod{Entity: entity, Value: value})
}
func (this *PlantTaskPresenter) Filters(ctx context.Context) []filter.Filter {
	filters := filter.Filters{}
	filters.AddIdFilter("id")
	filters.AddStringFilter("name")
	filters.AddRelationIdFilter("plant_id")
	return filters
}
