package presenters

// |@@| C

import (
	"context"
	"gardening/src/lib/filter"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/illustrers/plantation"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantationPresenter struct {
	AppUrler                         *urlers.AppUrler
	GardenStringer                   *stringers.GardenStringer
	Kit                              *kit.Kit
	PlantStringer                    *stringers.PlantStringer
	PlantationPrimaryColumnIllustrer *illustrers.PlantationPrimaryColumnIllustrer
	PlantationSearchIllustrer        *illustrers.PlantationSearchIllustrer
	Presenter                        *presenter.Presenter
}

func (this *PlantationPresenter) PrimaryColumn(ctx context.Context, entity *mdl.Plantation) goc.HTML {
	return this.PlantationPrimaryColumnIllustrer.Act(ctx, &illustrers.PlantationPrimaryColumnIllustrerMod{Entity: entity})
}
func (this *PlantationPresenter) IdDataColumn(entity *mdl.Plantation) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *PlantationPresenter) CreatedAtDataColumn(entity *mdl.Plantation) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *PlantationPresenter) UpdatedAtDataColumn(entity *mdl.Plantation) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *PlantationPresenter) NameDataColumn(entity *mdl.Plantation) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *PlantationPresenter) PlantedAtDataColumn(entity *mdl.Plantation) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.PlantedAt.Format("02/01/2006 15:04"))
}
func (this *PlantationPresenter) PlantIdDataColumn(entity *mdl.Plantation) goc.HTML {
	return this.Kit.Atoms.Cells.RelationCell.RelationCell(
		entity.Id, this.PlantStringer.MustToString(entity.Plant),
		this.AppUrler.ShowPlant(entity.Id),
	)
}
func (this *PlantationPresenter) GardenIdDataColumn(entity *mdl.Plantation) goc.HTML {
	return this.Kit.Atoms.Cells.RelationCell.RelationCell(
		entity.Id, this.GardenStringer.MustToString(entity.Garden),
		this.AppUrler.ShowGarden(entity.Id),
	)
}
func (this *PlantationPresenter) ColumnByKey(key string, entity *mdl.Plantation) goc.HTML {
	switch key {
	case "id":
		return this.IdDataColumn(entity)
	case "created_at":
		return this.CreatedAtDataColumn(entity)
	case "updated_at":
		return this.UpdatedAtDataColumn(entity)
	case "name":
		return this.NameDataColumn(entity)
	case "planted_at":
		return this.PlantedAtDataColumn(entity)
	case "plant_id":
		return this.PlantIdDataColumn(entity)
	case "garden_id":
		return this.GardenIdDataColumn(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *PlantationPresenter) Columns(filter string) []*presenter.Column {
	var columns []*presenter.Column
	columns = append(columns, &presenter.Column{
		Key:   "id",
		Label: "Id",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "created_at",
		Label: "Created At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "updated_at",
		Label: "Updated At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "name",
		Label: "Name",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "planted_at",
		Label: "Planted At",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "plant_id",
		Label: "Plant",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "garden_id",
		Label: "Garden",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	return this.Presenter.FilteredColumns(columns, filter)
}
func (this *PlantationPresenter) Search(ctx context.Context, value *searcher.SearchValue, entity *mdl.Plantation) goc.HTML {
	return this.PlantationSearchIllustrer.Act(ctx, &illustrers.PlantationSearchIllustrerMod{Entity: entity, Value: value})
}
func (this *PlantationPresenter) Filters(ctx context.Context) []filter.Filter {
	filters := filter.Filters{}
	filters.AddIdFilter("id")
	filters.AddStringFilter("name")
	filters.AddRelationIdFilter("plant_id")
	filters.AddRelationIdFilter("garden_id")
	return filters
}
