package presenters

// |@@| C

import (
	"context"
	"gardening/src/lib/filter"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/illustrers/seed_program"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type SeedProgramPresenter struct {
	AppUrler                          *urlers.AppUrler
	Kit                               *kit.Kit
	PlantStringer                     *stringers.PlantStringer
	Presenter                         *presenter.Presenter
	SeedProgramPrimaryColumnIllustrer *illustrers.SeedProgramPrimaryColumnIllustrer
	SeedProgramSearchIllustrer        *illustrers.SeedProgramSearchIllustrer
}

func (this *SeedProgramPresenter) PrimaryColumn(ctx context.Context, entity *mdl.SeedProgram) goc.HTML {
	return this.SeedProgramPrimaryColumnIllustrer.Act(ctx, &illustrers.SeedProgramPrimaryColumnIllustrerMod{Entity: entity})
}
func (this *SeedProgramPresenter) IdDataColumn(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *SeedProgramPresenter) CreatedAtDataColumn(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *SeedProgramPresenter) UpdatedAtDataColumn(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *SeedProgramPresenter) ContactDataColumn(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Contact)
}
func (this *SeedProgramPresenter) DescriptionDataColumn(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Description)
}
func (this *SeedProgramPresenter) NameDataColumn(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *SeedProgramPresenter) PlantIdDataColumn(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.RelationCell.RelationCell(
		entity.Id, this.PlantStringer.MustToString(entity.Plant),
		this.AppUrler.ShowPlant(entity.Id),
	)
}
func (this *SeedProgramPresenter) ColumnByKey(key string, entity *mdl.SeedProgram) goc.HTML {
	switch key {
	case "id":
		return this.IdDataColumn(entity)
	case "created_at":
		return this.CreatedAtDataColumn(entity)
	case "updated_at":
		return this.UpdatedAtDataColumn(entity)
	case "contact":
		return this.ContactDataColumn(entity)
	case "description":
		return this.DescriptionDataColumn(entity)
	case "name":
		return this.NameDataColumn(entity)
	case "plant_id":
		return this.PlantIdDataColumn(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *SeedProgramPresenter) Columns(filter string) []*presenter.Column {
	var columns []*presenter.Column
	columns = append(columns, &presenter.Column{
		Key:   "id",
		Label: "Id",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "created_at",
		Label: "Created At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "updated_at",
		Label: "Updated At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "contact",
		Label: "Contact",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "description",
		Label: "Description",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "name",
		Label: "Name",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	columns = append(columns, &presenter.Column{
		Key:   "plant_id",
		Label: "Plant",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	return this.Presenter.FilteredColumns(columns, filter)
}
func (this *SeedProgramPresenter) Search(ctx context.Context, value *searcher.SearchValue, entity *mdl.SeedProgram) goc.HTML {
	return this.SeedProgramSearchIllustrer.Act(ctx, &illustrers.SeedProgramSearchIllustrerMod{Entity: entity, Value: value})
}
func (this *SeedProgramPresenter) Filters(ctx context.Context) []filter.Filter {
	filters := filter.Filters{}
	filters.AddIdFilter("id")
	filters.AddStringFilter("contact")
	filters.AddStringFilter("name")
	filters.AddRelationIdFilter("plant_id")
	return filters
}
