package presenters

// |@@| C

import (
	"context"
	"gardening/src/lib/filter"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/illustrers/user"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UserPresenter struct {
	Kit                        *kit.Kit
	Presenter                  *presenter.Presenter
	UserPrimaryColumnIllustrer *illustrers.UserPrimaryColumnIllustrer
	UserSearchIllustrer        *illustrers.UserSearchIllustrer
}

func (this *UserPresenter) PrimaryColumn(ctx context.Context, entity *mdl.User) goc.HTML {
	return this.UserPrimaryColumnIllustrer.Act(ctx, &illustrers.UserPrimaryColumnIllustrerMod{Entity: entity})
}
func (this *UserPresenter) IdDataColumn(entity *mdl.User) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *UserPresenter) CreatedAtDataColumn(entity *mdl.User) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *UserPresenter) UpdatedAtDataColumn(entity *mdl.User) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *UserPresenter) NameDataColumn(entity *mdl.User) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *UserPresenter) ColumnByKey(key string, entity *mdl.User) goc.HTML {
	switch key {
	case "id":
		return this.IdDataColumn(entity)
	case "created_at":
		return this.CreatedAtDataColumn(entity)
	case "updated_at":
		return this.UpdatedAtDataColumn(entity)
	case "name":
		return this.NameDataColumn(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *UserPresenter) Columns(filter string) []*presenter.Column {
	var columns []*presenter.Column
	columns = append(columns, &presenter.Column{
		Key:   "id",
		Label: "Id",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "created_at",
		Label: "Created At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "updated_at",
		Label: "Updated At",
		Kind:  "data",
		Main:  false,
		Sub:   false,
	})
	columns = append(columns, &presenter.Column{
		Key:   "name",
		Label: "Name",
		Kind:  "data",
		Main:  true,
		Sub:   true,
	})
	return this.Presenter.FilteredColumns(columns, filter)
}
func (this *UserPresenter) Search(ctx context.Context, value *searcher.SearchValue, entity *mdl.User) goc.HTML {
	return this.UserSearchIllustrer.Act(ctx, &illustrers.UserSearchIllustrerMod{Entity: entity, Value: value})
}
func (this *UserPresenter) Filters(ctx context.Context) []filter.Filter {
	filters := filter.Filters{}
	filters.AddIdFilter("id")
	filters.AddStringFilter("name")
	return filters
}
