package relationers

// |@@| C

import (
	"context"
	"gardening/src/lib/relationer"
	"gardening/src/mdl"
	"gardening/src/srv/fetchers"
)

type PlantTaskRelationer struct {
	PlantFetcher *fetchers.PlantFetcher
	Relationer   *relationer.Relationer
}

func (this *PlantTaskRelationer) DistributePlant(ctx context.Context, set []*mdl.PlantTask, setToMerge []*mdl.Plant) {
	m := make(map[string]*mdl.Plant)
	for _, itemToMerge := range setToMerge {
		m[itemToMerge.Id] = itemToMerge
	}
	for _, item := range set {
		itemToMerge := m[item.PlantId]
		item.Plant = itemToMerge
	}
}
func (this *PlantTaskRelationer) HydratePlant(ctx context.Context, set []*mdl.PlantTask, mod *relationer.RelationerMod) error {
	ids := this.GetPlantIds(ctx, set)
	if len(ids) == 0 {
		return nil
	}
	setToMerge, err := this.PlantFetcher.FindSetIn(ctx, ids, this.Relationer.GetFetcherMod(mod))
	if err != nil {
		return err
	}
	this.DistributePlant(ctx, set, setToMerge)
	return nil
}
func (this *PlantTaskRelationer) GetPlantIds(ctx context.Context, set []*mdl.PlantTask) []string {
	return this.Relationer.GetUniqueIds(ctx, func() []string {
		var ids []string
		for _, item := range set {
			ids = append(ids, item.PlantId)
		}
		return ids
	})
}
