package relationers

// |@@| C

import (
	"context"
	"gardening/src/lib/relationer"
	"gardening/src/mdl"
	"gardening/src/srv/fetchers"
)

type SeedProgramRelationer struct {
	PlantFetcher *fetchers.PlantFetcher
	Relationer   *relationer.Relationer
}

func (this *SeedProgramRelationer) DistributePlant(ctx context.Context, set []*mdl.SeedProgram, setToMerge []*mdl.Plant) {
	m := make(map[string]*mdl.Plant)
	for _, itemToMerge := range setToMerge {
		m[itemToMerge.Id] = itemToMerge
	}
	for _, item := range set {
		itemToMerge := m[item.PlantId]
		item.Plant = itemToMerge
	}
}
func (this *SeedProgramRelationer) HydratePlant(ctx context.Context, set []*mdl.SeedProgram, mod *relationer.RelationerMod) error {
	ids := this.GetPlantIds(ctx, set)
	if len(ids) == 0 {
		return nil
	}
	setToMerge, err := this.PlantFetcher.FindSetIn(ctx, ids, this.Relationer.GetFetcherMod(mod))
	if err != nil {
		return err
	}
	this.DistributePlant(ctx, set, setToMerge)
	return nil
}
func (this *SeedProgramRelationer) GetPlantIds(ctx context.Context, set []*mdl.SeedProgram) []string {
	return this.Relationer.GetUniqueIds(ctx, func() []string {
		var ids []string
		for _, item := range set {
			ids = append(ids, item.PlantId)
		}
		return ids
	})
}
