package searchers

// |@@| C

import (
	"context"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/presenters"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
	"strings"
)

type GardenSearcher struct {
	AppUrler        *urlers.AppUrler
	GardenFetcher   *fetchers.GardenFetcher
	GardenPresenter *presenters.GardenPresenter
	GardenStringer  *stringers.GardenStringer
	Searcher        *searcher.Searcher
}

func (this *GardenSearcher) SearchValues(ctx context.Context) []searcher.SearchValue {
	var values []searcher.SearchValue
	entities := this.GardenFetcher.MustFindAll(ctx, nil)
	for _, entity := range entities {
		value := searcher.SearchValue{
			Id:      "garden_" + entity.Id,
			Text:    strings.ToLower(this.GardenStringer.MustToString(entity)),
			ModelId: entity.Id,
			Model:   "garden",
			Url:     this.AppUrler.ShowGarden(entity.Id),
			Scope:   this.getScope(ctx, entity),
		}
		values = append(values, value)
	}
	return values
}
func (this *GardenSearcher) GetSearchItem(ctx context.Context, value searcher.SearchValue) goc.HTML {
	id := value.ModelId
	entity := this.GardenFetcher.ShallFindOneById(ctx, id, nil)
	return this.GardenPresenter.Search(ctx, &value, entity)
}
func (this *GardenSearcher) getScope(ctx context.Context, entity *mdl.Garden) []*searcher.ScopeItem {
	var items []*searcher.ScopeItem
	return items
}
