package searchers

// |@@| C

import (
	"context"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/presenters"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
	"strings"
)

type GardenTaskSearcher struct {
	AppUrler            *urlers.AppUrler
	GardenTaskFetcher   *fetchers.GardenTaskFetcher
	GardenTaskPresenter *presenters.GardenTaskPresenter
	GardenTaskStringer  *stringers.GardenTaskStringer
	Searcher            *searcher.Searcher
}

func (this *GardenTaskSearcher) SearchValues(ctx context.Context) []searcher.SearchValue {
	var values []searcher.SearchValue
	entities := this.GardenTaskFetcher.MustFindAll(ctx, nil)
	for _, entity := range entities {
		value := searcher.SearchValue{
			Id:      "garden_task_" + entity.Id,
			Text:    strings.ToLower(this.GardenTaskStringer.MustToString(entity)),
			ModelId: entity.Id,
			Model:   "garden_task",
			Url:     this.AppUrler.ShowGardenTask(entity.Id),
			Scope:   this.getScope(ctx, entity),
		}
		values = append(values, value)
	}
	return values
}
func (this *GardenTaskSearcher) GetSearchItem(ctx context.Context, value searcher.SearchValue) goc.HTML {
	id := value.ModelId
	entity := this.GardenTaskFetcher.ShallFindOneById(ctx, id, nil)
	return this.GardenTaskPresenter.Search(ctx, &value, entity)
}
func (this *GardenTaskSearcher) getScope(ctx context.Context, entity *mdl.GardenTask) []*searcher.ScopeItem {
	var items []*searcher.ScopeItem
	return items
}
