package searchers

// |@@| C

import (
	"context"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/presenters"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
	"strings"
)

type PlantSearcher struct {
	AppUrler       *urlers.AppUrler
	PlantFetcher   *fetchers.PlantFetcher
	PlantPresenter *presenters.PlantPresenter
	PlantStringer  *stringers.PlantStringer
	Searcher       *searcher.Searcher
}

func (this *PlantSearcher) SearchValues(ctx context.Context) []searcher.SearchValue {
	var values []searcher.SearchValue
	entities := this.PlantFetcher.MustFindAll(ctx, nil)
	for _, entity := range entities {
		value := searcher.SearchValue{
			Id:      "plant_" + entity.Id,
			Text:    strings.ToLower(this.PlantStringer.MustToString(entity)),
			ModelId: entity.Id,
			Model:   "plant",
			Url:     this.AppUrler.ShowPlant(entity.Id),
			Scope:   this.getScope(ctx, entity),
		}
		values = append(values, value)
	}
	return values
}
func (this *PlantSearcher) GetSearchItem(ctx context.Context, value searcher.SearchValue) goc.HTML {
	id := value.ModelId
	entity := this.PlantFetcher.ShallFindOneById(ctx, id, nil)
	return this.PlantPresenter.Search(ctx, &value, entity)
}
func (this *PlantSearcher) getScope(ctx context.Context, entity *mdl.Plant) []*searcher.ScopeItem {
	var items []*searcher.ScopeItem
	return items
}
