package searchers

// |@@| C

import (
	"context"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/presenters"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
	"strings"
)

type PlantTaskSearcher struct {
	AppUrler           *urlers.AppUrler
	PlantTaskFetcher   *fetchers.PlantTaskFetcher
	PlantTaskPresenter *presenters.PlantTaskPresenter
	PlantTaskStringer  *stringers.PlantTaskStringer
	Searcher           *searcher.Searcher
}

func (this *PlantTaskSearcher) SearchValues(ctx context.Context) []searcher.SearchValue {
	var values []searcher.SearchValue
	entities := this.PlantTaskFetcher.MustFindAll(ctx, nil)
	for _, entity := range entities {
		value := searcher.SearchValue{
			Id:      "plant_task_" + entity.Id,
			Text:    strings.ToLower(this.PlantTaskStringer.MustToString(entity)),
			ModelId: entity.Id,
			Model:   "plant_task",
			Url:     this.AppUrler.ShowPlantTask(entity.Id),
			Scope:   this.getScope(ctx, entity),
		}
		values = append(values, value)
	}
	return values
}
func (this *PlantTaskSearcher) GetSearchItem(ctx context.Context, value searcher.SearchValue) goc.HTML {
	id := value.ModelId
	entity := this.PlantTaskFetcher.ShallFindOneById(ctx, id, nil)
	return this.PlantTaskPresenter.Search(ctx, &value, entity)
}
func (this *PlantTaskSearcher) getScope(ctx context.Context, entity *mdl.PlantTask) []*searcher.ScopeItem {
	var items []*searcher.ScopeItem
	return items
}
