package searchers

// |@@| C

import (
	"context"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/presenters"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
	"strings"
)

type PlantationSearcher struct {
	AppUrler            *urlers.AppUrler
	PlantationFetcher   *fetchers.PlantationFetcher
	PlantationPresenter *presenters.PlantationPresenter
	PlantationStringer  *stringers.PlantationStringer
	Searcher            *searcher.Searcher
}

func (this *PlantationSearcher) SearchValues(ctx context.Context) []searcher.SearchValue {
	var values []searcher.SearchValue
	entities := this.PlantationFetcher.MustFindAll(ctx, nil)
	for _, entity := range entities {
		value := searcher.SearchValue{
			Id:      "plantation_" + entity.Id,
			Text:    strings.ToLower(this.PlantationStringer.MustToString(entity)),
			ModelId: entity.Id,
			Model:   "plantation",
			Url:     this.AppUrler.ShowPlantation(entity.Id),
			Scope:   this.getScope(ctx, entity),
		}
		values = append(values, value)
	}
	return values
}
func (this *PlantationSearcher) GetSearchItem(ctx context.Context, value searcher.SearchValue) goc.HTML {
	id := value.ModelId
	entity := this.PlantationFetcher.ShallFindOneById(ctx, id, nil)
	return this.PlantationPresenter.Search(ctx, &value, entity)
}
func (this *PlantationSearcher) getScope(ctx context.Context, entity *mdl.Plantation) []*searcher.ScopeItem {
	var items []*searcher.ScopeItem
	return items
}
