package searchers

// |@@| C

import (
	"context"
	"gardening/src/lib/searcher"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type Searchers struct {
	GardenSearcher      *GardenSearcher
	GardenTaskSearcher  *GardenTaskSearcher
	PlantSearcher       *PlantSearcher
	PlantTaskSearcher   *PlantTaskSearcher
	PlantationSearcher  *PlantationSearcher
	Searcher            *searcher.Searcher
	SeedProgramSearcher *SeedProgramSearcher
	UserSearcher        *UserSearcher
}

func (this *Searchers) Indexing(ctx context.Context) []searcher.SearchValue {
	var values []searcher.SearchValue
	values = append(values, this.GardenSearcher.SearchValues(ctx)...)
	values = append(values, this.GardenTaskSearcher.SearchValues(ctx)...)
	values = append(values, this.PlantSearcher.SearchValues(ctx)...)
	values = append(values, this.PlantTaskSearcher.SearchValues(ctx)...)
	values = append(values, this.PlantationSearcher.SearchValues(ctx)...)
	values = append(values, this.SeedProgramSearcher.SearchValues(ctx)...)
	values = append(values, this.UserSearcher.SearchValues(ctx)...)
	return values
}
func (this *Searchers) GetSearchItem(ctx context.Context, value searcher.SearchValue) goc.HTML {
	switch value.Model {
	case "garden":
		return this.GardenSearcher.GetSearchItem(ctx, value)
	case "garden_task":
		return this.GardenTaskSearcher.GetSearchItem(ctx, value)
	case "plant":
		return this.PlantSearcher.GetSearchItem(ctx, value)
	case "plant_task":
		return this.PlantTaskSearcher.GetSearchItem(ctx, value)
	case "plantation":
		return this.PlantationSearcher.GetSearchItem(ctx, value)
	case "seed_program":
		return this.SeedProgramSearcher.GetSearchItem(ctx, value)
	case "user":
		return this.UserSearcher.GetSearchItem(ctx, value)
	}
	return goc.HTML{}
}
func (this *Searchers) GetSearchItems(ctx context.Context, values []searcher.SearchValue) []goc.HTML {
	var items []goc.HTML
	for _, value := range values {
		items = append(items, this.GetSearchItem(ctx, value))
	}
	return items
}
