package searchers

// |@@| C

import (
	"context"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/presenters"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
	"strings"
)

type SeedProgramSearcher struct {
	AppUrler             *urlers.AppUrler
	Searcher             *searcher.Searcher
	SeedProgramFetcher   *fetchers.SeedProgramFetcher
	SeedProgramPresenter *presenters.SeedProgramPresenter
	SeedProgramStringer  *stringers.SeedProgramStringer
}

func (this *SeedProgramSearcher) SearchValues(ctx context.Context) []searcher.SearchValue {
	var values []searcher.SearchValue
	entities := this.SeedProgramFetcher.MustFindAll(ctx, nil)
	for _, entity := range entities {
		value := searcher.SearchValue{
			Id:      "seed_program_" + entity.Id,
			Text:    strings.ToLower(this.SeedProgramStringer.MustToString(entity)),
			ModelId: entity.Id,
			Model:   "seed_program",
			Url:     this.AppUrler.ShowSeedProgram(entity.Id),
			Scope:   this.getScope(ctx, entity),
		}
		values = append(values, value)
	}
	return values
}
func (this *SeedProgramSearcher) GetSearchItem(ctx context.Context, value searcher.SearchValue) goc.HTML {
	id := value.ModelId
	entity := this.SeedProgramFetcher.ShallFindOneById(ctx, id, nil)
	return this.SeedProgramPresenter.Search(ctx, &value, entity)
}
func (this *SeedProgramSearcher) getScope(ctx context.Context, entity *mdl.SeedProgram) []*searcher.ScopeItem {
	var items []*searcher.ScopeItem
	return items
}
