package searchers

// |@@| C

import (
	"context"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/presenters"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
	"strings"
)

type UserSearcher struct {
	AppUrler      *urlers.AppUrler
	Searcher      *searcher.Searcher
	UserFetcher   *fetchers.UserFetcher
	UserPresenter *presenters.UserPresenter
	UserStringer  *stringers.UserStringer
}

func (this *UserSearcher) SearchValues(ctx context.Context) []searcher.SearchValue {
	var values []searcher.SearchValue
	entities := this.UserFetcher.MustFindAll(ctx, nil)
	for _, entity := range entities {
		value := searcher.SearchValue{
			Id:      "user_" + entity.Id,
			Text:    strings.ToLower(this.UserStringer.MustToString(entity)),
			ModelId: entity.Id,
			Model:   "user",
			Url:     this.AppUrler.ShowUser(entity.Id),
			Scope:   this.getScope(ctx, entity),
		}
		values = append(values, value)
	}
	return values
}
func (this *UserSearcher) GetSearchItem(ctx context.Context, value searcher.SearchValue) goc.HTML {
	id := value.ModelId
	entity := this.UserFetcher.ShallFindOneById(ctx, id, nil)
	return this.UserPresenter.Search(ctx, &value, entity)
}
func (this *UserSearcher) getScope(ctx context.Context, entity *mdl.User) []*searcher.ScopeItem {
	var items []*searcher.ScopeItem
	return items
}
