package sections

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/dat/maes"
	"gardening/src/lib/html_bridge"
	"gardening/src/lib/kit"
	"gardening/src/srv/form_presenters"
	"gardening/src/srv/urlers"
	forms2 "gitlab.com/ccyrillee/kitcla/components/organisms/forms"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type FormSection struct {
	AppUrler                      *urlers.AppUrler
	Kit                           *kit.Kit
	UpdateGardenTaskFormPresenter *form_presenters.UpdateGardenTaskFormPresenter
}

func (this *FormSection) H(out *maes.EditGardenTaskMaeOut) goc.HTML {
	return this.Kit.Component.Cas("section",
		goc.Attr{"class": "flex flex-col border px-4 my-4 py-4 bg-scale-0 rounded"},
		this.form(out),
	)
}
func (this *FormSection) form(out *maes.EditGardenTaskMaeOut) goc.HTML {
	fields := html_bridge.FormFields(out.Response.FormFields, "edit")
	bag := this.Kit.Organisms.Forms.Form.EmptyBag()
	target := this.AppUrler.UpdateGardenTask(out.In.Request.Form.Id)
	mod := this.Kit.Organisms.Forms.Form.Mod()
	mod.AddRedirect("Show it", "")
	mod.AddRedirect("Another", out.In.Context.Location)
	form := this.Kit.Organisms.Forms.Form.Form(out.Response.Form, fields, target, bag, this.field, mod)
	return this.Kit.Component.Cs("div", form)
}
func (this *FormSection) field(f interface{}, formField *forms2.FormField) goc.HTML {
	form := f.(forms.UpdateGardenTaskForm)
	convertedField := html_bridge.ConvertKitToLibFormField(formField)
	return this.UpdateGardenTaskFormPresenter.FieldByKey(&form, convertedField)
}
