package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
	"strconv"
)

type GridSection struct {
	AppUrler *urlers.AppUrler
	Kit      *kit.Kit
}

func (this *GridSection) H(out *maes.HomeMaeOut) goc.HTML {
	return this.Kit.Component.H("section",
		this.Kit.Component.Dcs("grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-4",
			this.gridItems(out)...,
		),
	)
}
func (this *GridSection) gridItems(out *maes.HomeMaeOut) []goc.HTML {
	var items []goc.HTML
	items = append(items, this.gridCard("Gardens", this.AppUrler.ListGardens(), out.Response.GardenCount))
	items = append(items, this.gridCard("Garden Tasks", this.AppUrler.ListGardenTasks(), out.Response.GardenTaskCount))
	items = append(items, this.gridCard("Plants", this.AppUrler.ListPlants(), out.Response.PlantCount))
	items = append(items, this.gridCard("Plant Tasks", this.AppUrler.ListPlantTasks(), out.Response.PlantTaskCount))
	items = append(items, this.gridCard("Plantations", this.AppUrler.ListPlantations(), out.Response.PlantationCount))
	items = append(items, this.gridCard("Seed Programs", this.AppUrler.ListSeedPrograms(), out.Response.SeedProgramCount))
	items = append(items, this.gridCard("Users", this.AppUrler.ListUsers(), out.Response.UserCount))
	return items
}
func (this *GridSection) gridCard(name string, url string, count int) goc.HTML {
	countS := strconv.Itoa(count)
	return goc.H("a", goc.Attr{"class": "bg-scale-0 rounded-lg shadow flex flex-col cursor-pointer", "href": url},
		goc.H("div", goc.Attr{"class": "my-5 mx-6  flex flex-row space-x-4 items-center"},
			goc.H("div", goc.Attr{"class": "flex flex-row items-baseline space-x-2"},
				goc.H("div", goc.Attr{"class": "text-xl"},
					name,
				),
				goc.H("div", goc.Attr{"class": "text-scale-6 text font-medium"},
					countS,
				),
			),
		),
	)
}
