package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type TitleSection struct {
	AppUrler *urlers.AppUrler
	Kit      *kit.Kit
}

func (this *TitleSection) H(maeOut *maes.HomeMaeOut) goc.HTML {
	return goc.H("section",
		goc.Attr{"class": "flex justify-between"},
		this.h1(maeOut),
		this.buttons(maeOut),
	)
}
func (this *TitleSection) h1(maeOut *maes.HomeMaeOut) goc.HTML {
	return this.Kit.Atoms.Headers.Header.H1("Home")
}
func (this *TitleSection) seeWeatherForecast(maeOut *maes.HomeMaeOut) goc.HTML {
	return this.Kit.Atoms.Buttons.Button.SecondaryLink("Weather forecast", this.AppUrler.DisplayWeatherForecast(), nil)
}
func (this *TitleSection) performReporting(maeOut *maes.HomeMaeOut) goc.HTML {
	return this.Kit.Atoms.Buttons.Button.SecondaryLink("Renew orders", this.AppUrler.SeeRenewOrders(), nil)
}
func (this *TitleSection) buttons(maeOut *maes.HomeMaeOut) goc.HTML {
	return goc.H("div",
		goc.Attr{"class": "flex flex-row space-x-2"},
		this.seeWeatherForecast(maeOut),
		this.performReporting(maeOut),
	)
}
