package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	bridge "gardening/src/lib/html_bridge"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/presenters"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/atoms/icons"
	"gitlab.com/ccyrillee/kitcla/components/organisms/tables"
	kitclaDat "gitlab.com/ccyrillee/kitcla/dat"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListSection struct {
	AppUrler           *urlers.AppUrler
	Kit                *kit.Kit
	PlantTaskPresenter *presenters.PlantTaskPresenter
}

func (this *ListSection) H(out *maes.ListPlantTasksMaeOut) goc.HTML {
	return this.Kit.Component.Cas("section",
		goc.Attr{"class": ""},
		this.table(out),
	)
}
func (this *ListSection) table(out *maes.ListPlantTasksMaeOut) goc.HTML {
	items := this.toItems(out.Response.PlantTasks)
	columns := this.getColumns(out)
	columns = this.Kit.Organisms.Tables.Table.SetWidthsWithBestEffort(columns)
	fetcherPagination := out.Response.PlantTasksPagination
	pagination := bridge.ConvertPagination(fetcherPagination)
	mod := &tables.TableMod{
		TableId:        "plant_tasks",
		Columns:        columns,
		Items:          items,
		Pagination:     pagination,
		BaseUrl:        out.In.Context.Location,
		RowCell:        this.rowCell,
		AllowedFilters: bridge.AllowedFilters(fetcherPagination.Modulation),
	}

	return this.Kit.Organisms.Tables.Table.H(mod)
}
func (this *ListSection) rowCellActions(item *mdl.PlantTask) goc.HTML {
	showPlantTaskButton := this.Kit.Atoms.Buttons.Button.TableIconLink(icons.IconEye, this.AppUrler.ShowPlantTask(item.Id), nil)
	editPlantTaskButton := this.Kit.Atoms.Buttons.Button.TableIconLink(icons.IconPenToSquare, this.AppUrler.EditPlantTask(item.Id), nil)
	dropdown := this.rowCellActionsDropdown(item)
	buttons := this.Kit.Component.Wrap("flex space-x-2", showPlantTaskButton, editPlantTaskButton, dropdown)
	return this.Kit.Component.Ccs("td", this.Kit.Organisms.Tables.Table.TdCss(), buttons)
}
func (this *ListSection) rowCellActionsDropdown(item *mdl.PlantTask) goc.HTML {
	deleteForm := this.Kit.Organisms.Forms.DeleteForm.DeleteForm(this.AppUrler.DeletePlantTask(item.Id))

	return this.Kit.Atoms.Dropdowns.Dropdown.EllipsisDropdown([]goc.HTML{
		deleteForm,
	})
}
func (this *ListSection) rowCell(item kitclaDat.Entity, column *tables.Column) goc.HTML {

	entity := item.(*mdl.PlantTask)
	if column.Kind == tables.ColumnKindData {
		cell := this.PlantTaskPresenter.ColumnByKey(column.Key, entity)
		return this.Kit.Component.Ccs("td", this.Kit.Organisms.Tables.Table.TdCss(), cell)
	}
	if column.Kind == tables.ColumnKindAction {
		return this.rowCellActions(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *ListSection) toItems(entities []*mdl.PlantTask) []kitclaDat.Entity {
	items := make([]kitclaDat.Entity, len(entities))
	for i, v := range entities {
		items[i] = v
	}
	return items
}
func (this *ListSection) getColumns(out *maes.ListPlantTasksMaeOut) []*tables.Column {
	presenterColumns := out.Response.List.Columns
	tableColumns := bridge.TableColumns(presenterColumns)
	tableColumns = this.Kit.Organisms.Tables.Table.Columns(tableColumns)
	return tableColumns
}
