package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type TitleSection struct {
	AppUrler *urlers.AppUrler
	Kit      *kit.Kit
}

func (this *TitleSection) H(out *maes.ListPlantTasksMaeOut) goc.HTML {
	return this.Kit.Component.H("section",
		goc.Attr{"class": "flex justify-between"},
		this.h1(out),
		this.newButton(out),
	)
}
func (this *TitleSection) h1(out *maes.ListPlantTasksMaeOut) goc.HTML {
	return this.Kit.Atoms.Headers.Header.H1("List plant tasks")
}
func (this *TitleSection) newButton(out *maes.ListPlantTasksMaeOut) goc.HTML {
	return this.Kit.Atoms.Buttons.Button.SecondaryLink("New plant task", this.AppUrler.NewPlantTask(), nil)
}
