package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	bridge "gardening/src/lib/html_bridge"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/presenters"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/atoms/icons"
	"gitlab.com/ccyrillee/kitcla/components/organisms/tables"
	kitclaDat "gitlab.com/ccyrillee/kitcla/dat"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListSection struct {
	AppUrler            *urlers.AppUrler
	Kit                 *kit.Kit
	PlantationPresenter *presenters.PlantationPresenter
}

func (this *ListSection) H(out *maes.ListPlantationsMaeOut) goc.HTML {
	return this.Kit.Component.Cas("section",
		goc.Attr{"class": ""},
		this.table(out),
	)
}
func (this *ListSection) table(out *maes.ListPlantationsMaeOut) goc.HTML {
	items := this.toItems(out.Response.Plantations)
	columns := this.getColumns(out)
	columns = this.Kit.Organisms.Tables.Table.SetWidthsWithBestEffort(columns)
	fetcherPagination := out.Response.PlantationsPagination
	pagination := bridge.ConvertPagination(fetcherPagination)
	mod := &tables.TableMod{
		TableId:        "plantations",
		Columns:        columns,
		Items:          items,
		Pagination:     pagination,
		BaseUrl:        out.In.Context.Location,
		RowCell:        this.rowCell,
		AllowedFilters: bridge.AllowedFilters(fetcherPagination.Modulation),
	}

	return this.Kit.Organisms.Tables.Table.H(mod)
}
func (this *ListSection) rowCellActions(item *mdl.Plantation) goc.HTML {
	showPlantationButton := this.Kit.Atoms.Buttons.Button.TableIconLink(icons.IconEye, this.AppUrler.ShowPlantation(item.Id), nil)
	editPlantationButton := this.Kit.Atoms.Buttons.Button.TableIconLink(icons.IconPenToSquare, this.AppUrler.EditPlantation(item.Id), nil)
	dropdown := this.rowCellActionsDropdown(item)
	buttons := this.Kit.Component.Wrap("flex space-x-2", showPlantationButton, editPlantationButton, dropdown)
	return this.Kit.Component.Ccs("td", this.Kit.Organisms.Tables.Table.TdCss(), buttons)
}
func (this *ListSection) rowCellActionsDropdown(item *mdl.Plantation) goc.HTML {
	deleteForm := this.Kit.Organisms.Forms.DeleteForm.DeleteForm(this.AppUrler.DeletePlantation(item.Id))

	return this.Kit.Atoms.Dropdowns.Dropdown.EllipsisDropdown([]goc.HTML{
		deleteForm,
	})
}
func (this *ListSection) rowCell(item kitclaDat.Entity, column *tables.Column) goc.HTML {

	entity := item.(*mdl.Plantation)
	if column.Kind == tables.ColumnKindData {
		cell := this.PlantationPresenter.ColumnByKey(column.Key, entity)
		return this.Kit.Component.Ccs("td", this.Kit.Organisms.Tables.Table.TdCss(), cell)
	}
	if column.Kind == tables.ColumnKindAction {
		return this.rowCellActions(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *ListSection) toItems(entities []*mdl.Plantation) []kitclaDat.Entity {
	items := make([]kitclaDat.Entity, len(entities))
	for i, v := range entities {
		items[i] = v
	}
	return items
}
func (this *ListSection) getColumns(out *maes.ListPlantationsMaeOut) []*tables.Column {
	presenterColumns := out.Response.List.Columns
	tableColumns := bridge.TableColumns(presenterColumns)
	tableColumns = this.Kit.Organisms.Tables.Table.Columns(tableColumns)
	return tableColumns
}
