package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	bridge "gardening/src/lib/html_bridge"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/presenters"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/atoms/icons"
	"gitlab.com/ccyrillee/kitcla/components/organisms/tables"
	kitclaDat "gitlab.com/ccyrillee/kitcla/dat"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListSection struct {
	AppUrler      *urlers.AppUrler
	Kit           *kit.Kit
	UserPresenter *presenters.UserPresenter
}

func (this *ListSection) H(out *maes.ListUsersMaeOut) goc.HTML {
	return this.Kit.Component.Cas("section",
		goc.Attr{"class": ""},
		this.table(out),
	)
}
func (this *ListSection) table(out *maes.ListUsersMaeOut) goc.HTML {
	items := this.toItems(out.Response.Users)
	columns := this.getColumns(out)
	columns = this.Kit.Organisms.Tables.Table.SetWidthsWithBestEffort(columns)
	fetcherPagination := out.Response.UsersPagination
	pagination := bridge.ConvertPagination(fetcherPagination)
	mod := &tables.TableMod{
		TableId:        "users",
		Columns:        columns,
		Items:          items,
		Pagination:     pagination,
		BaseUrl:        out.In.Context.Location,
		RowCell:        this.rowCell,
		AllowedFilters: bridge.AllowedFilters(fetcherPagination.Modulation),
	}

	return this.Kit.Organisms.Tables.Table.H(mod)
}
func (this *ListSection) rowCellActions(item *mdl.User) goc.HTML {
	showUserButton := this.Kit.Atoms.Buttons.Button.TableIconLink(icons.IconEye, this.AppUrler.ShowUser(item.Id), nil)
	editUserButton := this.Kit.Atoms.Buttons.Button.TableIconLink(icons.IconPenToSquare, this.AppUrler.EditUser(item.Id), nil)
	dropdown := this.rowCellActionsDropdown(item)
	buttons := this.Kit.Component.Wrap("flex space-x-2", showUserButton, editUserButton, dropdown)
	return this.Kit.Component.Ccs("td", this.Kit.Organisms.Tables.Table.TdCss(), buttons)
}
func (this *ListSection) rowCellActionsDropdown(item *mdl.User) goc.HTML {
	deleteForm := this.Kit.Organisms.Forms.DeleteForm.DeleteForm(this.AppUrler.DeleteUser(item.Id))

	return this.Kit.Atoms.Dropdowns.Dropdown.EllipsisDropdown([]goc.HTML{
		deleteForm,
	})
}
func (this *ListSection) rowCell(item kitclaDat.Entity, column *tables.Column) goc.HTML {

	entity := item.(*mdl.User)
	if column.Kind == tables.ColumnKindData {
		cell := this.UserPresenter.ColumnByKey(column.Key, entity)
		return this.Kit.Component.Ccs("td", this.Kit.Organisms.Tables.Table.TdCss(), cell)
	}
	if column.Kind == tables.ColumnKindAction {
		return this.rowCellActions(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *ListSection) toItems(entities []*mdl.User) []kitclaDat.Entity {
	items := make([]kitclaDat.Entity, len(entities))
	for i, v := range entities {
		items[i] = v
	}
	return items
}
func (this *ListSection) getColumns(out *maes.ListUsersMaeOut) []*tables.Column {
	presenterColumns := out.Response.List.Columns
	tableColumns := bridge.TableColumns(presenterColumns)
	tableColumns = this.Kit.Organisms.Tables.Table.Columns(tableColumns)
	return tableColumns
}
