package sections

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/dat/maes"
	"gardening/src/lib/html_bridge"
	"gardening/src/lib/kit"
	"gardening/src/srv/form_presenters"
	"gardening/src/srv/urlers"
	forms2 "gitlab.com/ccyrillee/kitcla/components/organisms/forms"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type FormSection struct {
	AppUrler                 *urlers.AppUrler
	CreatePlantFormPresenter *form_presenters.CreatePlantFormPresenter
	Kit                      *kit.Kit
}

func (this *FormSection) H(out *maes.NewPlantMaeOut) goc.HTML {
	return this.Kit.Component.Cas("section",
		goc.Attr{"class": "flex flex-col border px-4 my-4 py-4 bg-scale-0 rounded"},
		this.form(out),
	)
}
func (this *FormSection) form(out *maes.NewPlantMaeOut) goc.HTML {
	fields := html_bridge.FormFields(out.Response.FormFields, "new")
	bag := html_bridge.ConvertBag(out.Response.FormBag)
	target := this.AppUrler.CreatePlant()
	mod := this.Kit.Organisms.Forms.Form.Mod()
	mod.AddRedirect("Show it", "")
	mod.AddRedirect("Another", out.In.Context.Location)
	form := this.Kit.Organisms.Forms.Form.Form(out.Response.Form, fields, target, bag, this.field, mod)
	return this.Kit.Component.Cs("div", form)
}
func (this *FormSection) field(f interface{}, formField *forms2.FormField) goc.HTML {
	form := f.(forms.CreatePlantForm)
	convertedField := html_bridge.ConvertKitToLibFormField(formField)
	return this.CreatePlantFormPresenter.FieldByKey(&form, convertedField)
}
