package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/fetchers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type SeeSection struct {
	Kit          *kit.Kit
	EventFetcher *fetchers.EventFetcher
}

func (this *SeeSection) H(out *maes.SeeEventsMaeOut) goc.HTML {
	return this.Kit.Component.Cs("section", this.card(out))
}

func (this *SeeSection) displayEvents(out *maes.SeeEventsMaeOut) goc.HTML {
	events := this.EventFetcher.MustFindAll(out.Ctx, nil)

	var set []goc.HTML

	for _, event := range events {
		set = append(set, this.displayEvent(event))
	}

	return this.Kit.Component.Ds(set...)
}

func (this *SeeSection) card(out *maes.SeeEventsMaeOut) goc.HTML {
	return this.Kit.Organisms.Cards.Card.SimpleCard("Last ones", this.displayEvents(out))
}

func (this *SeeSection) displayEvent(event *mdl.Event) goc.HTML {
	return this.Kit.Component.Dv(event.What)
}
