package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/show_presenters"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/atoms/icons"
	"gitlab.com/ccyrillee/kitcla/goc"
	"strings"
)

type ShowSection struct {
	AppUrler            *urlers.AppUrler
	GardenShowPresenter *show_presenters.GardenShowPresenter
	Kit                 *kit.Kit
}

func (this *ShowSection) H(out *maes.ShowGardenMaeOut) goc.HTML {
	return this.Kit.Component.Cas("section",
		goc.Attr{"class": "flex flex-row space-x-4"},
		this.Kit.Component.Wrap("w-full", this.showCard(out)),
	)
}
func (this *ShowSection) showCard(out *maes.ShowGardenMaeOut) goc.HTML {
	content := this.showCardContent(out)
	popover := this.Kit.Molecules.Popovers.Popover.IconPopoverWithFixedWidth(icons.IconFasClockRotateLeft,
		this.Kit.Component.Dcs("flex flex-col",
			this.showInfoData(out),
			this.showEventsData(out)),
		"320",
	)
	mixed := this.Kit.Component.Dcs("flex flex-row space-x-2",
		content, popover,
	)
	return this.Kit.Organisms.Cards.Card.ShowCard(mixed)
}
func (this *ShowSection) showCardContent(out *maes.ShowGardenMaeOut) goc.HTML {
	entity := out.Response.Garden
	items := this.Kit.Organisms.Grids.KeyValueGrid.NewItems()

	items = this.Kit.Organisms.Grids.KeyValueGrid.AppendItem(items, "name", this.GardenShowPresenter.FieldByKey("name", entity))
	items = this.Kit.Organisms.Grids.KeyValueGrid.AppendItem(items, "picture", this.GardenShowPresenter.FieldByKey("picture", entity))

	return this.Kit.Organisms.Grids.KeyValueGrid.KeyValueGrid(items)
}
func (this *ShowSection) showInfoData(out *maes.ShowGardenMaeOut) goc.HTML {
	entity := out.Response.Garden
	items := this.Kit.Organisms.Tables.KeyValueTable.NewItems()

	items = this.Kit.Organisms.Tables.KeyValueTable.AppendItem(items, "Updated at", this.Kit.Atoms.Cells.TimeCell.TimeCell(entity.UpdatedAt))
	items = this.Kit.Organisms.Tables.KeyValueTable.AppendItem(items, "Updated by", this.Kit.Atoms.Cells.TextCell.TextCell("admin"))
	items = this.Kit.Organisms.Tables.KeyValueTable.AppendItem(items, "Created at", this.Kit.Atoms.Cells.TimeCell.TimeCell(entity.CreatedAt))

	table := this.Kit.Organisms.Tables.KeyValueTable.KeyValueTable(items, "w-1/2", "w-1/2")

	return table
}
func (this *ShowSection) showEventsData(out *maes.ShowGardenMaeOut) goc.HTML {
	var items []goc.HTML

	if len(out.Response.Events) == 0 {
		return this.Kit.Component.C("div")
	}

	for _, event := range out.Response.Events {
		s := ""
		if strings.HasPrefix(event.What, "create_") {
			s = "Created at "
		}
		if strings.HasPrefix(event.What, "update_") {
			s = "Updated at "
		}
		s += event.When.Format("02/01/2006")
		s += " by " + event.Who
		g := this.Kit.Component.Dcv("py-4", s)
		items = append(items, g)
	}
	collection := this.Kit.Component.Dcs("flex flex-col divide-y divide-scale-3 text-scale-6", items...)

	return collection
}
