package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type TitleSection struct {
	AppUrler *urlers.AppUrler
	Kit      *kit.Kit
}

func (this *TitleSection) H(out *maes.ShowGardenTaskMaeOut) goc.HTML {
	return this.Kit.Component.H("section",
		goc.Attr{"class": "flex justify-between"},
		this.h1(out),
		this.editButton(out),
	)
}
func (this *TitleSection) h1(out *maes.ShowGardenTaskMaeOut) goc.HTML {
	return this.Kit.Atoms.Headers.Header.H1("Show garden task")
}
func (this *TitleSection) editButton(out *maes.ShowGardenTaskMaeOut) goc.HTML {
	return this.Kit.Atoms.Buttons.Button.SecondaryLink("Edit garden task", this.AppUrler.EditGardenTask(out.In.Request.Id), nil)
}
