package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	bridge "gardening/src/lib/html_bridge"
	"gardening/src/lib/kit"
	"gardening/src/lib/urler"
	"gardening/src/mdl"
	"gardening/src/srv/presenters"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/atoms/icons"
	"gitlab.com/ccyrillee/kitcla/components/organisms/tables"
	kitclaDat "gitlab.com/ccyrillee/kitcla/dat"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantationsListSection struct {
	AppUrler            *urlers.AppUrler
	Kit                 *kit.Kit
	PlantationPresenter *presenters.PlantationPresenter
}

func (this *PlantationsListSection) H(out *maes.ShowPlantMaeOut) goc.HTML {
	return this.Kit.Component.Cas("section",
		goc.Attr{"class": ""},
		this.table(out),
	)
}
func (this *PlantationsListSection) table(out *maes.ShowPlantMaeOut) goc.HTML {
	items := this.toItems(out.Response.Plantations)
	columns := this.getColumns(out)
	columns = this.Kit.Organisms.Tables.Table.SetWidthsWithBestEffort(columns)
	fetcherPagination := out.Response.PlantationsPagination
	pagination := bridge.ConvertPagination(fetcherPagination)
	mod := &tables.TableMod{
		TableId:      "plantations",
		Columns:      columns,
		Items:        items,
		Pagination:   pagination,
		BaseUrl:      out.In.Context.Location,
		RowCell:      this.rowCell,
		Title:        "Plantation",
		NewEntityUrl: this.AppUrler.NewPlantation(urler.StringParam("form[plant_id]", out.In.Request.Id)),
		FullTableUrl: this.AppUrler.ListPlantations(urler.StringParam("filters[fields][plant_id][eq]", out.In.Request.Id)),
	}

	return this.Kit.Organisms.Tables.Table.SubTable(mod)
}
func (this *PlantationsListSection) rowCellActions(item *mdl.Plantation) goc.HTML {
	showPlantationButton := this.Kit.Atoms.Buttons.Button.TableIconLink(icons.IconEye, this.AppUrler.ShowPlantation(item.Id), nil)
	editPlantationButton := this.Kit.Atoms.Buttons.Button.TableIconLink(icons.IconPenToSquare, this.AppUrler.EditPlantation(item.Id), nil)
	dropdown := this.rowCellActionsDropdown(item)
	buttons := this.Kit.Component.Wrap("flex space-x-2", showPlantationButton, editPlantationButton, dropdown)
	return this.Kit.Component.Ccs("td", this.Kit.Organisms.Tables.Table.TdCss(), buttons)
}
func (this *PlantationsListSection) rowCellActionsDropdown(item *mdl.Plantation) goc.HTML {
	deleteForm := this.Kit.Organisms.Forms.DeleteForm.DeleteForm(this.AppUrler.DeletePlantation(item.Id))

	return this.Kit.Atoms.Dropdowns.Dropdown.EllipsisDropdown([]goc.HTML{
		deleteForm,
	})
}
func (this *PlantationsListSection) rowCell(item kitclaDat.Entity, column *tables.Column) goc.HTML {

	entity := item.(*mdl.Plantation)
	if column.Kind == tables.ColumnKindData {
		cell := this.PlantationPresenter.ColumnByKey(column.Key, entity)
		return this.Kit.Component.Ccs("td", this.Kit.Organisms.Tables.Table.TdCss(), cell)
	}
	if column.Kind == tables.ColumnKindAction {
		return this.rowCellActions(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *PlantationsListSection) toItems(entities []*mdl.Plantation) []kitclaDat.Entity {
	items := make([]kitclaDat.Entity, len(entities))
	for i, v := range entities {
		items[i] = v
	}
	return items
}
func (this *PlantationsListSection) getColumns(out *maes.ShowPlantMaeOut) []*tables.Column {
	presenterColumns := this.PlantationPresenter.Columns("sub")
	tableColumns := bridge.TableColumns(presenterColumns)
	tableColumns = this.Kit.Organisms.Tables.Table.Columns(tableColumns)
	return tableColumns
}
