package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	bridge "gardening/src/lib/html_bridge"
	"gardening/src/lib/kit"
	"gardening/src/lib/urler"
	"gardening/src/mdl"
	"gardening/src/srv/presenters"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/atoms/icons"
	"gitlab.com/ccyrillee/kitcla/components/organisms/tables"
	kitclaDat "gitlab.com/ccyrillee/kitcla/dat"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type SeedProgramsListSection struct {
	AppUrler             *urlers.AppUrler
	Kit                  *kit.Kit
	SeedProgramPresenter *presenters.SeedProgramPresenter
}

func (this *SeedProgramsListSection) H(out *maes.ShowPlantMaeOut) goc.HTML {
	return this.Kit.Component.Cas("section",
		goc.Attr{"class": ""},
		this.table(out),
	)
}
func (this *SeedProgramsListSection) table(out *maes.ShowPlantMaeOut) goc.HTML {
	items := this.toItems(out.Response.SeedPrograms)
	columns := this.getColumns(out)
	columns = this.Kit.Organisms.Tables.Table.SetWidthsWithBestEffort(columns)
	fetcherPagination := out.Response.SeedProgramsPagination
	pagination := bridge.ConvertPagination(fetcherPagination)
	mod := &tables.TableMod{
		TableId:      "seed_programs",
		Columns:      columns,
		Items:        items,
		Pagination:   pagination,
		BaseUrl:      out.In.Context.Location,
		RowCell:      this.rowCell,
		Title:        "Seed Program",
		NewEntityUrl: this.AppUrler.NewSeedProgram(urler.StringParam("form[plant_id]", out.In.Request.Id)),
		FullTableUrl: this.AppUrler.ListSeedPrograms(urler.StringParam("filters[fields][plant_id][eq]", out.In.Request.Id)),
	}

	return this.Kit.Organisms.Tables.Table.SubTable(mod)
}
func (this *SeedProgramsListSection) rowCellActions(item *mdl.SeedProgram) goc.HTML {
	showSeedProgramButton := this.Kit.Atoms.Buttons.Button.TableIconLink(icons.IconEye, this.AppUrler.ShowSeedProgram(item.Id), nil)
	editSeedProgramButton := this.Kit.Atoms.Buttons.Button.TableIconLink(icons.IconPenToSquare, this.AppUrler.EditSeedProgram(item.Id), nil)
	dropdown := this.rowCellActionsDropdown(item)
	buttons := this.Kit.Component.Wrap("flex space-x-2", showSeedProgramButton, editSeedProgramButton, dropdown)
	return this.Kit.Component.Ccs("td", this.Kit.Organisms.Tables.Table.TdCss(), buttons)
}
func (this *SeedProgramsListSection) rowCellActionsDropdown(item *mdl.SeedProgram) goc.HTML {
	deleteForm := this.Kit.Organisms.Forms.DeleteForm.DeleteForm(this.AppUrler.DeleteSeedProgram(item.Id))

	return this.Kit.Atoms.Dropdowns.Dropdown.EllipsisDropdown([]goc.HTML{
		deleteForm,
	})
}
func (this *SeedProgramsListSection) rowCell(item kitclaDat.Entity, column *tables.Column) goc.HTML {

	entity := item.(*mdl.SeedProgram)
	if column.Kind == tables.ColumnKindData {
		cell := this.SeedProgramPresenter.ColumnByKey(column.Key, entity)
		return this.Kit.Component.Ccs("td", this.Kit.Organisms.Tables.Table.TdCss(), cell)
	}
	if column.Kind == tables.ColumnKindAction {
		return this.rowCellActions(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *SeedProgramsListSection) toItems(entities []*mdl.SeedProgram) []kitclaDat.Entity {
	items := make([]kitclaDat.Entity, len(entities))
	for i, v := range entities {
		items[i] = v
	}
	return items
}
func (this *SeedProgramsListSection) getColumns(out *maes.ShowPlantMaeOut) []*tables.Column {
	presenterColumns := this.SeedProgramPresenter.Columns("sub")
	tableColumns := bridge.TableColumns(presenterColumns)
	tableColumns = this.Kit.Organisms.Tables.Table.Columns(tableColumns)
	return tableColumns
}
