package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/show_presenters"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/atoms/icons"
	"gitlab.com/ccyrillee/kitcla/goc"
	"strings"
)

type ShowSection struct {
	AppUrler           *urlers.AppUrler
	Kit                *kit.Kit
	PlantShowPresenter *show_presenters.PlantShowPresenter
}

func (this *ShowSection) H(out *maes.ShowPlantMaeOut) goc.HTML {
	return this.Kit.Component.Cas("section",
		goc.Attr{"class": "flex flex-row space-x-4"},
		this.Kit.Component.Wrap("w-full", this.showCard(out)),
	)
}
func (this *ShowSection) showCard(out *maes.ShowPlantMaeOut) goc.HTML {
	content := this.showCardContent(out)
	popover := this.Kit.Molecules.Popovers.Popover.IconPopoverWithFixedWidth(icons.IconFasClockRotateLeft,
		this.Kit.Component.Dcs("flex flex-col",
			this.showInfoData(out),
			this.showEventsData(out)),
		"320",
	)
	mixed := this.Kit.Component.Dcs("flex flex-row space-x-2",
		content, popover,
	)
	return this.Kit.Organisms.Cards.Card.ShowCard(mixed)
}
func (this *ShowSection) showCardContent(out *maes.ShowPlantMaeOut) goc.HTML {
	entity := out.Response.Plant
	items := this.Kit.Organisms.Grids.KeyValueGrid.NewItems()

	items = this.Kit.Organisms.Grids.KeyValueGrid.AppendItem(items, "data", this.PlantShowPresenter.FieldByKey("data", entity))
	items = this.Kit.Organisms.Grids.KeyValueGrid.AppendItem(items, "description", this.PlantShowPresenter.FieldByKey("description", entity))
	items = this.Kit.Organisms.Grids.KeyValueGrid.AppendItem(items, "exposition", this.PlantShowPresenter.FieldByKey("exposition", entity))
	items = this.Kit.Organisms.Grids.KeyValueGrid.AppendItem(items, "harvested", this.PlantShowPresenter.FieldByKey("harvested", entity))
	items = this.Kit.Organisms.Grids.KeyValueGrid.AppendItem(items, "name", this.PlantShowPresenter.FieldByKey("name", entity))
	items = this.Kit.Organisms.Grids.KeyValueGrid.AppendItem(items, "perennial", this.PlantShowPresenter.FieldByKey("perennial", entity))
	items = this.Kit.Organisms.Grids.KeyValueGrid.AppendItem(items, "reference", this.PlantShowPresenter.FieldByKey("reference", entity))
	items = this.Kit.Organisms.Grids.KeyValueGrid.AppendItem(items, "size", this.PlantShowPresenter.FieldByKey("size", entity))

	return this.Kit.Organisms.Grids.KeyValueGrid.KeyValueGrid(items)
}
func (this *ShowSection) showInfoData(out *maes.ShowPlantMaeOut) goc.HTML {
	entity := out.Response.Plant
	items := this.Kit.Organisms.Tables.KeyValueTable.NewItems()

	items = this.Kit.Organisms.Tables.KeyValueTable.AppendItem(items, "Updated at", this.Kit.Atoms.Cells.TimeCell.TimeCell(entity.UpdatedAt))
	items = this.Kit.Organisms.Tables.KeyValueTable.AppendItem(items, "Updated by", this.Kit.Atoms.Cells.TextCell.TextCell("admin"))
	items = this.Kit.Organisms.Tables.KeyValueTable.AppendItem(items, "Created at", this.Kit.Atoms.Cells.TimeCell.TimeCell(entity.CreatedAt))

	table := this.Kit.Organisms.Tables.KeyValueTable.KeyValueTable(items, "w-1/2", "w-1/2")

	return table
}
func (this *ShowSection) showEventsData(out *maes.ShowPlantMaeOut) goc.HTML {
	var items []goc.HTML

	if len(out.Response.Events) == 0 {
		return this.Kit.Component.C("div")
	}

	for _, event := range out.Response.Events {
		s := ""
		if strings.HasPrefix(event.What, "create_") {
			s = "Created at "
		}
		if strings.HasPrefix(event.What, "update_") {
			s = "Updated at "
		}
		s += event.When.Format("02/01/2006")
		s += " by " + event.Who
		g := this.Kit.Component.Dcv("py-4", s)
		items = append(items, g)
	}
	collection := this.Kit.Component.Dcs("flex flex-col divide-y divide-scale-3 text-scale-6", items...)

	return collection
}
