package sections

// |@@| C

import (
	"gardening/src/dat/maes"
	bridge "gardening/src/lib/html_bridge"
	"gardening/src/lib/kit"
	"gardening/src/lib/urler"
	"gardening/src/mdl"
	"gardening/src/srv/presenters"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/atoms/icons"
	"gitlab.com/ccyrillee/kitcla/components/organisms/tables"
	kitclaDat "gitlab.com/ccyrillee/kitcla/dat"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type GardenTasksListSection struct {
	AppUrler            *urlers.AppUrler
	GardenTaskPresenter *presenters.GardenTaskPresenter
	Kit                 *kit.Kit
}

func (this *GardenTasksListSection) H(out *maes.ShowPlantationMaeOut) goc.HTML {
	return this.Kit.Component.Cas("section",
		goc.Attr{"class": ""},
		this.table(out),
	)
}
func (this *GardenTasksListSection) table(out *maes.ShowPlantationMaeOut) goc.HTML {
	items := this.toItems(out.Response.GardenTasks)
	columns := this.getColumns(out)
	columns = this.Kit.Organisms.Tables.Table.SetWidthsWithBestEffort(columns)
	fetcherPagination := out.Response.GardenTasksPagination
	pagination := bridge.ConvertPagination(fetcherPagination)
	mod := &tables.TableMod{
		TableId:      "garden_tasks",
		Columns:      columns,
		Items:        items,
		Pagination:   pagination,
		BaseUrl:      out.In.Context.Location,
		RowCell:      this.rowCell,
		Title:        "Garden Task",
		NewEntityUrl: this.AppUrler.NewGardenTask(urler.StringParam("form[plantation_id]", out.In.Request.Id)),
		FullTableUrl: this.AppUrler.ListGardenTasks(urler.StringParam("filters[fields][plantation_id][eq]", out.In.Request.Id)),
	}

	return this.Kit.Organisms.Tables.Table.SubTable(mod)
}
func (this *GardenTasksListSection) rowCellActions(item *mdl.GardenTask) goc.HTML {
	showGardenTaskButton := this.Kit.Atoms.Buttons.Button.TableIconLink(icons.IconEye, this.AppUrler.ShowGardenTask(item.Id), nil)
	editGardenTaskButton := this.Kit.Atoms.Buttons.Button.TableIconLink(icons.IconPenToSquare, this.AppUrler.EditGardenTask(item.Id), nil)
	dropdown := this.rowCellActionsDropdown(item)
	buttons := this.Kit.Component.Wrap("flex space-x-2", showGardenTaskButton, editGardenTaskButton, dropdown)
	return this.Kit.Component.Ccs("td", this.Kit.Organisms.Tables.Table.TdCss(), buttons)
}
func (this *GardenTasksListSection) rowCellActionsDropdown(item *mdl.GardenTask) goc.HTML {
	deleteForm := this.Kit.Organisms.Forms.DeleteForm.DeleteForm(this.AppUrler.DeleteGardenTask(item.Id))

	return this.Kit.Atoms.Dropdowns.Dropdown.EllipsisDropdown([]goc.HTML{
		deleteForm,
	})
}
func (this *GardenTasksListSection) rowCell(item kitclaDat.Entity, column *tables.Column) goc.HTML {

	entity := item.(*mdl.GardenTask)
	if column.Kind == tables.ColumnKindData {
		cell := this.GardenTaskPresenter.ColumnByKey(column.Key, entity)
		return this.Kit.Component.Ccs("td", this.Kit.Organisms.Tables.Table.TdCss(), cell)
	}
	if column.Kind == tables.ColumnKindAction {
		return this.rowCellActions(entity)
	}
	return this.Kit.Organisms.Tables.Table.EmptyCellRow()
}
func (this *GardenTasksListSection) toItems(entities []*mdl.GardenTask) []kitclaDat.Entity {
	items := make([]kitclaDat.Entity, len(entities))
	for i, v := range entities {
		items[i] = v
	}
	return items
}
func (this *GardenTasksListSection) getColumns(out *maes.ShowPlantationMaeOut) []*tables.Column {
	presenterColumns := this.GardenTaskPresenter.Columns("sub")
	tableColumns := bridge.TableColumns(presenterColumns)
	tableColumns = this.Kit.Organisms.Tables.Table.Columns(tableColumns)
	return tableColumns
}
